unit Tools1v2;
//=============================================================================
//          .
//           DELPHI
//  (c)  ..  2.1.  12.12.2009.
//=============================================================================
//     INTERFACE
//=============================================================================
interface

// ----------------------------------------------------------------------------
//       integer
function StrToIntPro (WStr : string; var WInt : integer) : boolean;

//       double
function StrToFloatPro (WStr : string; var WDouble : double) : boolean;

// ----------------------------------------------------------------------------
//  2.1.
//       X,Y, Z
procedure ShowArrayXYZ(RqXArray, RqYArray, RqZArray : array of double);

//  2.1.
//       X,Y
procedure ShowArrayXY(RqXArray, RqYArray : array of double);

//  2.1.
//      
procedure ShowArray(RqArray : array of double);

//     
procedure DWriteToArray(var RqArray : array of double);

//  2.1.
//       (0-RqRange)
procedure WriteRandomToArray (RqScale : double; RqRange : integer;
                               var RqArray : array of double);

//      
function FindIndArrayMin (RqArray : array of double): integer;

//      
function FindIndArrayMax (RqArray : array of double): integer;

// ----------------------------------------------------------------------------
//        
procedure FindAndShowArrayMinMax (RqArray : array of double);

// ----------------------------------------------------------------------------
//    
// RqUpDn = 'U' ( )
// RqUpDn = 'D' ( )
procedure SortArray(RqUpDn : char; var RqArray : array of double);

//=============================================================================
//     IMPLEMENTATION
//=============================================================================

implementation
uses SysUtils, AnsiTo866;


//=============================================================================
//           
//=============================================================================

//       integer
function StrToIntPro (WStr : string; var WInt : integer) : boolean;
begin
   Result:=False;      //  
   try
       WInt:= StrToInt(WStr);
       Result:=True;   //  
   except
       WriteLnRus (#09 + '(  integer)/ERROR(Text not integer)');
   end;
end;


// ----------------------------------------------------------------------------
//       double
function StrToFloatPro (WStr : string; var WDouble : double) : boolean;
begin
   Result:=False;     //  
   try
       WDouble:= StrToFloat(WStr);
       Result:=True;  //  
   except
       WriteLnRus (#09 + '(  double)/ERROR(Text not double)');
   end;
end;

//=============================================================================
//         double 
//=============================================================================

// ----------------------------------------------------------------------------
//       X,Y,Z
procedure ShowArrayXYZ(RqXArray, RqYArray, RqZArray : array of double);
var Ind    : word;    //  
    WStr   : string;  //  
begin
   WriteLn;
   WriteLnRus ('    X  Y/SHOW ARRAY X and Y');
   WriteLnRus ('Index' + #09 + 'ValueX'+ #09 + 'ValueY'+ #09 + 'ValueZ');
   for Ind:=Low(RqXArray) to High(RqXArray) do
   begin
      WStr := IntToStr(Ind);
      WStr := WStr + #09 + FloatToStrF(RqXArray[Ind],ffExponent,  8,3);
      WStr := WStr + #09 + FloatToStrF(RqYArray[Ind],ffExponent, 8,3);
      WStr := WStr + #09 + FloatToStrF(RqZArray[Ind],ffExponent, 8,3);
      WriteLn(WStr);
   end;
   WriteLn;
end;

// ----------------------------------------------------------------------------
//       X,Y
procedure ShowArrayXY(RqXArray, RqYArray : array of double);
var Ind    : word;    //  
    WStr   : string;  //  
begin
   WriteLn;
   WriteLnRus ('    X  Y/SHOW ARRAY X and Y');
   WriteLnRus ('Index' + #09 + 'ValueX'+ #09 + 'ValueY');
   for Ind:=Low(RqXArray) to High(RqXArray) do
   begin
      WStr := IntToStr(Ind);
      WStr := WStr + #09 + FloatToStrF(RqXArray[Ind],ffExponent,  8,3);
      WStr := WStr + #09 + FloatToStrF(RqYArray[Ind],ffExponent, 8,3);
      WriteLn(WStr);
   end;
   WriteLn;
end;

// ----------------------------------------------------------------------------
//      
procedure ShowArray(RqArray : array of double);
var Ind    : word;    //  
    WStr   : string;  //  
begin
   WriteLn;
   WriteLnRus ('   /SHOW ARRAY');
   WriteLnRus ('Index' + #09 + 'Value');
   for Ind:=Low(RqArray) to High(RqArray) do
   begin
      WStr := IntToStr(Ind);
      WStr := WStr + #09 + FloatToStrF(RqArray[Ind],ffExponent,  8,3);
      WriteLn(WStr);
   end;
   WriteLn;
end;

// ----------------------------------------------------------------------------
//       ( )
function StrToIntForArrayIndex (WStr : string; RqArray : array of double) : integer;
var BInt  : integer;
begin
   Result := Low(RqArray) - 1;  //   (index out range)
   if StrToIntPro(WStr, BInt)   //     integer
   then begin
     //      
     if (BInt >= Low(RqArray)) and (BInt <= High(RqArray))
     then begin
        Result := BInt ;      //  
     end
     else begin
       WriteLnRus (#09 + '(  )/ERROR(Index out range)');
     end;
   end;
end;

// ----------------------------------------------------------------------------
//     
procedure DWriteToArray(var RqArray : array of double);
var F1Quit  : boolean;  //      
    F2Quit  : boolean;  //      
    F3Ok    : boolean;  //   
    StrInd  : string;   //    
    StrVal  : string;   //    
    Ind     : integer;  //   
    Val     : double;   //   
begin
    WriteLn;
    WriteLn    ('==========================================');
    WriteLnRus ('  /IMPUT ARRAY ELEMENT.');
    WriteLnRus ('  /Index range ('
               + IntToStr(Low(RqArray))
               + '..'
               + IntToStr(High(RqArray))
               + ')'
               );
    WriteLn   ('------------------------------------------');

    Ind := Low(RqArray)-1;  //   (index out range)
    F1Quit := False;        //    
    repeat
       WriteRus ('   /Imput INDEX : ');
       ReadLn(StrInd);
       if UpCase(StrInd[1]) = 'Q'
       then begin
          //    
          F1Quit:=True;
       end
       else begin
          //        
          Ind := StrToIntForArrayIndex (StrInd, RqArray);
       end;
    until ((Ind >= Low(RqArray)) or F1Quit);

    F2Quit := False;  //    
    F3Ok   := False;  //    
    if (not F1Quit)
    then begin
       repeat
          WriteRus (' /Imput VALUE : ');
          ReadLn(StrVal);
          if UpCase(StrVal[1]) = 'Q'
          then F2Quit := True
          else F3Ok   := StrToFloatPro (StrVal, Val);
       until (F3Ok or F2Quit);
    end;
    //         ,
    //    
    if (not F1Quit) and (not F2Quit) and F3Ok
    then begin
       RqArray[Ind]:=Val;
       WriteLnRus ('   /SUCCESS');
    end
    else begin
       WriteLnRus (' /Operation CANCELED');
    end;
    WriteLn  ('==========================================');
    WriteLn;
end;

// ----------------------------------------------------------------------------
//       (0-RqRange)
procedure WriteRandomToArray (RqScale : double; RqRange : integer;
                               var RqArray : array of double);
var Ind  : integer;  //  
begin
 Randomize;
 for Ind:= Low(RqArray) to High(RqArray) do
 begin
   RqArray[Ind] := RqScale * Random(RqRange);
 end;
end;

// ----------------------------------------------------------------------------
//      
function FindIndArrayMin (RqArray : array of double): integer;
var Ind    : integer;   //  
    Min    : double;    //    
    IndMin : integer;   //   
begin
    //  
    IndMin := Low(RqArray);
    Min    := RqArray[IndMin];
    //  
    for Ind := Low(RqArray) to High(RqArray) do
    begin
        if Min > RqArray[Ind]
        then begin
           Min := RqArray[Ind];
           IndMin := Ind;
        end;
    end;
    Result := IndMin;
end;

// ----------------------------------------------------------------------------
//      
function FindIndArrayMax (RqArray : array of double): integer;
var Ind    : integer;   //  
    Max    : double;    //    
    IndMax : integer;   //   
begin
    //  
    IndMax := Low(RqArray);
    Max    := RqArray[IndMax];
    //  
    for Ind := Low(RqArray) to High(RqArray) do
    begin
        if Max < RqArray[Ind]
        then begin
           Max := RqArray[Ind];
           IndMax := Ind;
        end;
    end;
    Result := IndMax;
end;

// ----------------------------------------------------------------------------
//        
procedure FindAndShowArrayMinMax (RqArray : array of double);
var IndMin : integer;   //   
    IndMax : integer;   //   
begin
    IndMin := FindIndArrayMin (RqArray);
    IndMax := FindIndArrayMax (RqArray);
    // 
    WriteLn;
    WriteLnRus ('MIN-MAX   /MIN-MAX in ARRAY ');
    WriteLnRus ('MIN Index = '
              + IntToStr(IndMin)
              + #09                   //  
              + ' Value = '
              + FloatToStr(RqArray[IndMin])
              );
   WriteLnRus ('MAX Index = '
              + IntToStr(IndMax)
              + #09                   //  
              + ' Value = '
              + FloatToStr(RqArray[IndMax])
              );
   WriteLn;
end;

// ----------------------------------------------------------------------------
//    
// RqUpDn = 'U' ( )
// RqUpDn = 'D' ( )
procedure SortArray(RqUpDn : char; var RqArray : array of double);
var Ind    : integer;      //  
    IndSuf : integer;      //  
    ValBub : double;       //   
begin
    if Length(RqArray) > 1
    then begin
       //        
       for IndSuf := High(RqArray) downto Low(RqArray) do
       begin
          for Ind := Low(RqArray) to IndSuf do
          begin
             if ((Ind + 1) <= IndSuf)
             then begin
                //      
                case UpCase(RqUpDn) of
                'U' : begin //  
                     if (RqArray[Ind] > RqArray[Ind + 1])
                     then begin
                        //     
                        ValBub := RqArray[Ind + 1];
                        RqArray[Ind + 1] := RqArray[Ind];
                        RqArray[Ind] := ValBub;
                     end;
                 end;
                 'D' : begin //  
                     if (RqArray[Ind] < RqArray[Ind + 1])
                     then begin
                        //     
                        ValBub := RqArray[Ind + 1];
                        RqArray[Ind + 1] := RqArray[Ind];
                        RqArray[Ind] := ValBub;
                     end;
                 end;
                 end; // of case
             end; // of if ((Ind + 1) <= IndSuf)
          end; // of for Ind
       end; // of for IndSuf
    end; // of if length(RqArray)
end;
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

end.